global script_node

local controls = FindNodeByName("AllControlsScript")
local prop = FindNodeByName("Ob_5_2Prop")
local handlestate

handlestate = 1

--Heisenberg focusing device

global function AnimDone()
	local anim
	local ce2 = FindNodeByName("ce2")
	
	ce2:Trigger()
	
	if (handlestate == 0) then
		anim = FindNodeByShortName("EM_ANIMATOR_Heisenberg_Anim_Panel05_Heisenberg_Right_Idle")
	elseif (handlestate == 1) then
		anim = FindNodeByShortName("EM_ANIMATOR_Heisenberg_Anim_Panel05_Heisenberg_Idle")
	else
		anim = FindNodeByShortName("EM_ANIMATOR_Heisenberg_Anim_Panel05_Heisenberg_Left_Idle")
	end

	prop:PlayAnim(anim, 1, 0.25)
	FindNodeByName("Ob_5_2Sound"):StopTrigger()
	controls.script.TurnOnInterface()
	--Locking down mech
	controls.script.InteractDone()
end

global function Interact()
	local amy = GetActor("amy")
	local doctor = GetActor("doctor")
	local anim
	
	if (handlestate == 0) then
		anim = FindNodeByShortName("EM_ANIMATOR_Heisenberg_Anim_Panel05_Heisenberg_Right_To_Idle")
		handlestate = 1
	elseif (handlestate == 1) then
		anim = FindNodeByShortName("EM_ANIMATOR_Heisenberg_Anim_Panel05_Heisenberg_Left")
		handlestate = 2
	else
		anim = FindNodeByShortName("EM_ANIMATOR_Heisenberg_Anim_Panel05_Heisenberg_Right")
		handlestate = 0
	end

	FindNodeByName("Console5InteractableScript").script.Object2State = handlestate
	
	-- ConsoleDV == 0 is for when exploring tardis
	if controls.script.ConsoleDV == 0 then
		SayPrep("skip","async")

		if(FindNodeByName("CommonScripts").script.DoctorIsPlayer()) then
			--VO Console Control Text
			doctor::SID_2280:Heisenberg Focusing Device: You can observe a subatomic particle's position and state, but never both at once. This device compensates for that.
			-- VO Console Control Text
			doctor::SID_2281:Good old Werner Heisenberg, I renamed this after him when he helped me fix it. Lovely bloke, hated nuclear weapons, surprisingly good singer.
		else
			--VO Console Control Text
			amy::SID_2282:Another control the Doctor seems to mess around with at random. I don't think he actually knows how to fly this thing.
		end
	end

	controls.script.TurnOffInterface()
	FindNodeByName("Ob_5_2Sound"):Trigger()		
	prop:PlayAnim(anim, 1, 0)
	prop:SetCallback(script_node, "AnimDone")
end

global function DummyCallback()
end

global function ResetControl()
	local anim

	if handlestate == 0 then
		anim = FindNodeByShortName("EM_ANIMATOR_Heisenberg_Anim_Panel05_Heisenberg_Right_Idle")
--	elseif
--		anim = FindNodeByShortName("EM_ANIMATOR_Heisenberg_Anim_Panel05_Heisenberg_Left")
--	else
		anim = FindNodeByShortName("EM_ANIMATOR_Heisenberg_Anim_Panel05_Heisenberg_Right")
	end

	prop:SetCallback(script_node, "DummyCallback")
	prop:PlayAnim(anim, 1, 0.25)
	FindNodeByName("Ob_5_2Sound"):StopTrigger()
	handlestate = 0
end
